/*
 * FPSE null CD routines.
 *
 * By: linuzappz <linuzappz@hotmail.com>
 *
 *
 */

#include <stdio.h>

#include "type.h"
#include "cd.h"
#include "linuxdef.h"

#define VERSION		0x0100  // Version must be in BCD format

static FPSELinuxAbout info = {
    FPSE_CDROM,
    VERSION & 0xFF,
    VERSION >> 8,
    0,
    "LinuzAppz",
    "Null-CDROM",
    "This Plugin is a Null CD driver. It does nothing, only for testing.\x00d\x00a"
    "If you have some question or you've found a bug send an email to:\x00d\x00a"
    "<linuzappz@hotmail.com>"
};

#define DATA_SIZE	(2352-12)

static UINT8 cdbuffer[DATA_SIZE];

int CD_Open(UINT32 *par)
{
	memset (cdbuffer,0,DATA_SIZE);
	return FPSE_OK;
}

void CD_Close(void)
{
}

int CD_GetTN(UINT8 *result)
{
	return FPSE_OK;
}

int CD_GetTD(UINT8 *result,int track)
{
	return FPSE_OK;
}

int CD_Play(UINT8 *param)
{
	return FPSE_OK;
}

int CD_Stop(void)
{
	return FPSE_OK;
}

UINT8 *CD_Read(UINT8 *param)
{
	return cdbuffer;
}

void CD_GetSeek(UINT8 *par)
{
}


int CD_Wait()
{
	return FPSE_OK;
}


int CD_Configure(UINT32 *par)
{
	FPSELinux *conf = (FPSELinux *) par;

	conf->ConfCmd(0,NULL); /* start/reset */
	conf->ConfCmd(1,"Nothing To Configure"); /* print */
	conf->ConfCmd(0xf,NULL); /* wait and close */

	return FPSE_OK;
}


void CD_About(UINT32 *par)
{
	memcpy (par, &info, sizeof(FPSELinuxAbout));
}
